//------------------------------------------------------------------------------
// Tumar CSP
// Copyright (c) 2011 Scientific Lab. Gamma Technologies. All rights reserved.
// SDK
// Verify Signature TimeStamp message
//------------------------------------------------------------------------------
#include "ex_util.h"
//------------------------------------------------------------------------------
#define TSP_REP_FILE "tsp_rep.bin"
#define TSP_CERT     "tsp.cer"
//------------------------------------------------------------------------------
//           PKCS7
// :
// 1.     
//------------------------------------------------------------------------------
unsigned char WBuf[8196];
unsigned char Cert[8196];
//------------------------------------------------------------------------------
int main(void)
{
 int code;
 HCRYPTPROV hProv=0;
 HCRYPTKEY  hKey,sz,sc;

 //  
 code=LoadTumarCSP((char*)CSP_LIB); if (code) {printf("Load CSP error: %d\n",code); return 1;}
 //
 //  TimeStamp
 if (getFileLen(TSP_REP_FILE,    &sz)) {printf("getFileLen error\r\n"); return 1;}
 if (readFile  (TSP_REP_FILE,WBuf,sz)) {printf("readFile error\r\n");   return 1;}
 //
 //  
 if (getFileLen(TSP_CERT,    &sc)) {printf("getFileLen error\r\n"); return 1;}
 if (readFile  (TSP_CERT,Cert,sc)) {printf("readFile error\r\n");   return 1;}
 //
 //   CSP
 if (!CPAcquireContext(&hProv,NULL,CRYPT_VERIFYCONTEXT,NULL)) {
   printf("CPAcquireContext Error: %0X\n",GetLastErrorCSP(0));
   return 1;
 }
 //     
 if (!CPImportKey(hProv,Cert,sc,0,0,&hKey)) {
   printf("CPImportKey Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //  
 if (!CPVerifySignature(hProv,0,WBuf,sz,hKey,NULL,CRYPT_OBJECT_TSP)) {
   printf("CPVerifySignature Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 CPDestroyKey (hProv,hKey);
 //   CSP
 CPReleaseContext(hProv,0);
 printf("OK\n");
 return 0;
}
//------------------------------------------------------------------------------
